//--------------------------------------------------------------------------
//
// test program 4 for the indexed_priority_multimap container:
//
//   Randomly inserts and/or erases increasing or decreasing sequences of
//   integer-valued items.  These sequences have random lengths and starting
//   values.  The index differences are chosen randomly.
//
//      Copyright (c) 2005,2007  Pittsburgh Supercomputing Center
//
//      This program is free software; you can redistribute it and/or modify
//      it under the terms of the GNU General Public License as published by
//      the Free Software Foundation; either version 2 of the License, or
//      (at your option) any later version.
//
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.  Neither the
//      Pittsburgh Supercomputing Center nor any of the authors assume
//      any liability for damages, incidental or otherwise, caused by the
//      installation or use of this software.
//
//      You should have received a copy of the GNU General Public License
//      along with this program; if not, write to the Free Software
//      Foundation, Inc., 51 Franklin Street, Fifth Floor,
//      Boston, MA  02110-1301  USA
//
//
//	HISTORY
//      	11/05	Written by Greg Hood, PSC
//              1/07    Removed unnecessary #includes (ghood@psc.edu)
//
//--------------------------------------------------------------------------

#include <stdio.h>
#include <stdlib.h>
#include "pmap.h"

using pmap::indexed_priority_multimap;

main ()
{
  int i, n, ind, v, ud, ir;
  indexed_priority_multimap<int,int,int> t;
  indexed_priority_multimap<int,int,int>::const_iterator pos;

  printf("Test 4 started.\n");

  ud = 0;  // up/down sequence: 0 = down, 1 = up
  ir = 0;  // insert/remove: 0 = remove, 1 = insert
  for (i = 0; i < 100000; ++i)
    {
      n = (int) (1000.0 * drand48());
      ind = (int) (1024.0 * drand48());
      if (drand48() < 0.005)
	{
	  // start a new sequence with 0.5% probability
	  v = (int) (1024.0 * drand48());
	  ud = (int) (2.0 * drand48());
	  ir = (int) (2.0 * drand48());
	}
      else
	// continue the current sequence
	if (ud)
	  v = (v + 1) & 1023;
	else
	  v = (v + 1023) & 1023;

      if (ir)
	t.insert(n, v, ind);
      else
	{
	  pos = t.find(n);
	  if (pos != t.end())
	    t.erase(pos);
	}
    }

  printf("Test 4 succeeded.\n");
}

