#ifndef _PMAP_H
#define _PMAP_H

//--------------------------------------------------------------------------
//
//      pmap.h - header for priority_map, priority_multimap,
//               indexed_priority_map, indexed_priority_multimap
//
//      VERSION 1.0.0
//
//      Copyright (c) 2003,2005,2006,2014 Pittsburgh Supercomputing Center
//
//      This program is free software; you can redistribute it and/or modify
//      it under the terms of the GNU General Public License as published by
//      the Free Software Foundation; either version 2 of the License, or
//      (at your option) any later version.
//
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.  Neither the
//      Pittsburgh Supercomputing Center nor any of the authors assume
//      any liability for damages, incidental or otherwise, caused by the
//      installation or use of this software.
//
//      You should have received a copy of the GNU General Public License
//      along with this program; if not, write to the Free Software
//      Foundation, Inc., 51 Franklin Street, Fifth Floor,
//      Boston, MA  02110-1301  USA
//
//
//	HISTORY
//      	3/03	Written by Greg Hood, PSC
//              3/05    Removed NEOSIM dependencies (ghood@psc.edu)
//              10/05   Extended from indexed_priority_map (ghood@psc.edu)
//              3/14    Converted to use unordered_map instead of hash_map
//                        (ghood@psc.edu)
//
//--------------------------------------------------------------------------

//--------------------------------------------------------------------------
//      SITE-SPECIFIC DEFINES
//--------------------------------------------------------------------------
//   (These may be defined here, in the including program prior
//    to including this file, or on the compiler command line.)
//
// 1. Define _PMAP_HAVE_EXPORT only if the C++ compiler supports
//   exportable templates (gcc does not as of 3.4.2):
// #undef  _PMAP_HAVE_EXPORT              // for most C++ compilers
// #define _PMAP_HAVE_EXPORT              // for compilers that support export
//
// 2. Optionally define _PMAP_SIZE_TYPE to the type
//   that should be used for internal indexing of the container's data
//   structures.  This defaults to size_t, which should always be safe on all
//   architectures.  By defining it to a 32-bit type such as "unsigned int"
//   on a 64-bit machine that has less than 64GB of memory or where it is
//   known that the container will not need to hold more than 4 billion items,
//   one can substantially reduce the memory requirements of the container,
//   especially when the size of Key, Value (and Index) are small.
//   _PMAP_DIFFERENCE_TYPE should also be defined to be the corresponding
//   signed type.
// #define _PMAP_SIZE_TYPE		unsigned int  // only for <4x10^9 items
// #define _PMAP_DIFFERENCE_TYPE	int           // only for <4x10^9 items
//
// 3. Optionally define _PMAP_DEBUG if you want internal consistency
//    checking of the container's data structures before and after each
//    method's operations (this will slow down everything enormously,
//    so it is not recommended for production use)
// #undef  _PMAP_DEBUG                  // for regular usage
// #define _PMAP_DEBUG                  // while debugging these containers
//
//--------------------------------------------------------------------------
//      END OF SITE-SPECIFIC DEFINES
//--------------------------------------------------------------------------

// STL DEPENDENCIES
#include <iterator>
#include <memory>
#include <string>
#include <vector>
#include <unordered_map>

//   #ifndef _PMAP_TRIPLE
//   #define _PMAP_TRIPLE

namespace pmap
{
  // A triple is analogous to an STL pair template, except
  //   that it can hold three elements of arbitrary type
  //   This implementation is patterned after the GNU stl_pair.h
  //   implementation.
  template <class T1, class T2, class T3>
    struct triple
    {
      triple () : first(T1()), second(T2()), third(T3()) {};
      triple (const T1& x, const T2& y, const T3& z) :
	first(x), second(y), third(z) {};
      template <class U1, class U2, class U3>
	triple (const triple<U1, U2, U3>& x) :
	  first(x.first), second(x.second), third(x.third) {};

      T1 first;
      T2 second;
      T3 third;
    };

  template <class T1, class T2, class T3>
    inline bool operator== (const triple<T1, T2, T3>& x,
			    const triple<T1, T2, T3>& y)
    { 
      return(x.first == y.first &&
	     x.second == y.second &&
	     x.third == y.third);
    }

  template <class T1, class T2, class T3>
    inline bool operator< (const triple<T1, T2, T3>& x,
			   const triple<T1, T2, T3>& y)
    { 
      return(x.first < y.first || 
	     (!(y.first < x.first) &&
	      (x.second < y.second || (!(y.second < x.second) &&
				       x.third < y.third))));
    }

  template <class T1, class T2, class T3>
    inline bool operator!= (const triple<T1, T2, T3>& x,
			    const triple<T1, T2, T3>& y)
    {
      return(!(x == y));
    }

  template <class T1, class T2, class T3>
    inline bool operator> (const triple<T1, T2, T3>& x,
			   const triple<T1, T2, T3>& y)
    {
      return(y < x);
    }

  template <class T1, class T2, class T3>
    inline bool operator<= (const triple<T1, T2, T3>& x,
			    const triple<T1, T2, T3>& y)
    {
      return(!(y < x));
    }

  template <class T1, class T2, class T3>
    inline bool operator>= (const triple<T1, T2, T3>& x,
			    const triple<T1, T2, T3>& y)
    {
      return(!(x < y));
    }

  template <class T1, class T2, class T3>
    inline triple<T1, T2, T3> make_triple(const T1& x,
					  const T2& y,
					  const T3& z)
    {
      return(triple<T1, T2, T3>(x, y, z));
    }
}

//   #endif

#undef  _PMAP_CLASS
#define _PMAP_CLASS	priority_map
#undef  _PMAP_INDEXED
#undef  _PMAP_MULTI
#include "pmap_common.h"

#undef  _PMAP_CLASS
#define _PMAP_CLASS	priority_multimap
#undef  _PMAP_INDEXED
#define _PMAP_MULTI
#include "pmap_common.h"

#undef  _PMAP_CLASS
#define _PMAP_CLASS	indexed_priority_map
#define _PMAP_INDEXED
#undef  _PMAP_MULTI
#include "pmap_common.h"

#undef  _PMAP_CLASS
#define _PMAP_CLASS	indexed_priority_multimap
#define _PMAP_INDEXED
#define _PMAP_MULTI
#include "pmap_common.h"

#ifndef _PMAP_HAVE_EXPORT
#include "pmap.tcc"
#endif

#endif
